from picamera2 import Picamera2, Preview
import cv2
import time
import os
import sys
from datetime import datetime

def take_roi_frame_auto(picam2, results_folder):
    """
    Capture one ROI frame with live preview for manual focus.
    """
    # Create output folder
    roi_folder = os.path.join(results_folder, "Frames", "roi_frame")
    os.makedirs(roi_folder, exist_ok=True)

    # Configure preview stream
    config = picam2.create_preview_configuration(main={"size": (1280, 800)})
    picam2.configure(config)
    picam2.start_preview(Preview.DRM)
    picam2.start()

    print("📷 Live preview started.")
    print("👉 Adjust focus manually, then press Enter to capture.")
    print("🔘 Press ESC to quit.")

    frame_captured = False

    try:
        while True:
            frame = picam2.capture_array()
            cv2.imshow("Camera Preview", frame)
            key = cv2.waitKey(1)

            if key == 13:  # Enter key
                timestamp = datetime.now().strftime("%Y%m%d_%H%M%S")
                filename = os.path.join(roi_folder, f"frame_roi_{timestamp}.png")
                cv2.imwrite(filename, frame)
                print(f"✅ Image saved as: {filename}")
                frame_captured = True
                break

            elif key == 27:  # ESC key
                print("❌ Capture cancelled by user.")
                break

    finally:
        cv2.destroyAllWindows()
        picam2.stop_preview()
        picam2.stop()
        print("📷 Camera stopped and preview closed.")

    if frame_captured:
        print("Close the experimental box (or make necessary setup changes).Press Enter to continue...")
        input()

if __name__ == "__main__":
    if len(sys.argv) < 2:
        print("Usage: python roi_capture.py <results_folder>")
        sys.exit(1)

    results_folder_path = sys.argv[1]
    picam2 = Picamera2()
    take_roi_frame_auto(picam2, results_folder_path)

