﻿# Dataset on the development of an enhanced hybrid ZrO2/C catalyst for the ketonization of diluted aqueous acetic acid

### Jacopo De Maron1,2*, Aytan Safarova1, Catalin Ursu1, Gaetano Maria D’Onofrio1, Eleonora Tosi Brandi1, Andrea Fasolini1,2, Gloria Gottardi3, Francesco Basile1,2*, Fabrizio Cavani1,2, Tommaso Tabanelli1,2


Affiliations
1 “Toso Montanari” Department of Industrial Chemistry, University of Bologna, Viale del Risorgimento 4, Bologna 40136, Italy. 
2 Center for Chemical Catalysis-C3, University of Bologna, Viale del Risorgimento 4, 40136 Bologna, Italy.
3 Center for Sustainable Energy, Bruno Kessler Foundation, Via Sommarive 18, Trento 38123, Italy. 
Referring author: Jacopo De Maron - jacopo.demaron2@unibo.it

Licensing: This dataset is distributed under a **Creative Commons Attribution 4.0 International (CC BY 4.0)** license, https://creativecommons.org/licenses/by/4.0/ 

Publication year: **2025**

Project: NEST (Network 4 Energy Sustainable Transition) is an Extended Partnership funded under the National Recovery and Resilience Plan (NRRP, Missione 4 Componente 2 - Investimento 1.3, project number PE00000021) financed by the European Union within theNextGenerationEU programme. This dataset is the result of a collaboration between UNIBO (University of Bologna) and FBK (Foundation Bruno Kessler)in the frame of Spoke 9 “Energy-sustainable advanced materials”.

## Dataset content

This dataset consists of a .zip compressed file, named “Promoting_Zirconia_with_Carbon_Dataset.zip”, containing the following:

- “README.md”

- "reactions.csv"

- "EDS" folder containing:
	- "5ZrO2-C_01.png"
	- "5ZrO2-C_02.png"
	- "5ZrO2-C_03.png"
	- "15ZrO2-C_01.png"
	- "15ZrO2-C_02.png"
	- "15ZrO2-C_03.png"
	- "30ZrO2-C_01.png"
	- "30ZrO2-C_02.png"
	- "30ZrO2-C_03.png"
	- "elemental_analysis.csv"

- "N2_prorosimetry" folder containing:
	- "5ZrO2-C.csv"
	- "15ZrO2-C.csv"
	- "30ZrO2-C.csv"
	- "areas_pores.csv"
	- "C.csv"

- "Raman" folder containing:
	- "TiO2.csv"
	- "ZrO2.csv"

- "SEM" folder containing:
	- "5ZrO2-C_01.png"
	- "5ZrO2-C_02.png"
	- "15ZrO2-C_01.png"
	- "15ZrO2-C_02.png"
	- "30ZrO2-C_01.png"
	- "30ZrO2-C_02.png"
	- "C_01.png"
	- "TiO2_01.png"
	- "ZrO2_01.png"

- "TEM" folder containing:
	- "5ZrO2-C_01.png"
	- "5ZrO2-C_02.png"
	- "5ZrO2-C_03.png"
	- "5ZrO2-C_04.png"
	- "15ZrO2-C_01.png"
	- "15ZrO2-C_02.png"
	- "15ZrO2-C_03.png"
	- "15ZrO2-C_04.png"
	- "30ZrO2-C_01.png"
	- "30ZrO2-C_02.png"
	- "30ZrO2-C_03.png"
	- "30ZrO2-C_04.png"
	- "particle_size.csv"

- "TGA" folder containing:
	- "TiO2.csv"

- "XPS" folder containing:
	- "surface_elemental_analysis.csv"

- "XRD" folder containing:
	- "5ZrO2-C.csv"
	- "15ZrO2-C.csv"
	- "30ZrO2-C.csv"		
	- "C.csv"
	- "TiO2.csv"
	- "ZrO2.csv"

## Dataset documentation

### Abstract

The present dataset contains data related to the preparation of a series of novel hybrid catalysts consisting of zirconia supported over a hydrophobic activated carbon support by means of incipient wetness impregnation, and their use as catalysts for the ketonization of diluted aqueous solutions of acetic acid (AA) to acetone (AC). These novel catalysts were thoroughly characterized by means of several characterization techniques, such as XRD, TEM, N2 porosimetry, Raman spectroscopy and XPS, to assess structure-activity relationships. The data includes all the results of the catalytic tests, as well as the raw data of the materials characterization. The performance of the hybrid catalyst achieved in optimized condition was superior to that of benchmark bulk materials (ZrO2 and TiO2) and literature results. 

### Content of the files

- file "reactions.csv" contains the reaction conditions and main results of all the catalytic runs presented in the work. The parameters reported are:
	- “ReactionN°”: progressive number of the reactions carried out from 1 to 19 plus a “blank run”; these number are be used to designate samples characterized after the reaction.
       - “catalyst_name”: "ZrO2" is bulk zirconia, "Tio2" is bulk titania, "30ZrO2-C” is zirconia supported on activated carbon with 30 wt. % loading, "15ZrO2-C” is zirconia supported on activated carbon with 15 wt. % loading, "5ZrO2-C” is zirconia supported on activated carbon with 5 wt. % loading, “blank run” is a test carried out without catalyst;
       - “support” is the support used; none means that no support was present (bulk catalyst);  
       - “active_phase” is the active phase present, either bulk or supported on carbon; 
       - “active_phase_loading[wt.%]” is the loading of active phase expressed as wt. % of metal oxide;
       - “calcination_temperature[°C]” is the calcination temperature expressed in Celsius degrees;
       - “catalyst_mass[g]” is the catalyst mass loaded in the reactor expressed in grams;
       - “catalyst_volume[mL]” is the catalyst volume loaded in the reactor expressed in milliliters;
       - “reaction_temperature[°C]” is the reaction temperature expressed in degrees Celsius;
	- “contact_time[s]” is the contact time at reaction temperature expressed in seconds;
	- “feed_flow_rate[mL/min]” is the total feed flow rate (acetic acid+water+nitrogen) at reaction temperature expresse in milliliters per minute;
	- “feed_composition(AA/H2O/N2)[mol%]” is the feed composition expressed as the mol % of each component in the gas feed; 
	- “X_AA” is the conversion of acetica acid;
	- “Y_AC” is the yield of acetone;
	- “Y_CO2” is the yield of CO2;
	- “Y_M” is the yield of mesitylene;
	- “Y_Others” is the yield of unknow compounds;
	- “STY_CAT[h-1]” is the space time yield of acetone normalized by the mass of catalyst expressed as h-1
	- “STY_ZrO2[h-1]” is the space time yield of acetone normalized by 	the mass of active phase expressed as h-1.

-“EDS” folder:
       - file "elemental_analysis.csv" contains the relative amounts of carbon, oxygen and zirconium measured by means of EDS (energy levels: C K alpha, O K alpha, Zr L alpha) and expressed as atomic percentage, in “5ZrO2-C”, “15ZrO2-C”, and “30ZrO2-C”;
       - files "5ZrO2-C_01.png","15ZrO2-C_01.png", and "30ZrO2-C_01.png" contain the C K alpha elemental maps for the catalysts corresponding to the filename.
       - files "5ZrO2-C_02.png","15ZrO2-C_02.png", and "30ZrO2-C_02.png" contain the O K alpha elemental maps for the catalysts corresponding to the filename.
       - files "5ZrO2-C_03.png","15ZrO2-C_03.png", and "30ZrO2-C_03.png" contain the Zr L alpha elemental maps for the catalysts corresponding to the filename.

-"N2_porosimetry" folder:
       - files "5ZrO2-C.csv","15ZrO2-C.csv", and "30ZrO2-C.csv" contain the raw data of the multipoint N2 adsorption and desorption isotherms, the BJH pore size differential distribution (adsorption branch) and the BJH pore size incremental distribution (adsorption branch) for the catalysts corresponding to the filename.
       - file "C.csv" contains the raw data of the multipoint N2 adsorption and desorption isotherms, the BJH pore size differential distribution (adsorption branch), the BJH pore size incremental distribution (adsorption branch), and the BJH pore size differential distribution (desorption branch) for the carbon support.
       - file "areas_pores.csv" contains the multipoint BET specific surface area, the t-plot area of micropores, and the BJH area of mesopores (adsorption branch) expressed as m2/g for C, 5ZrO2-C, 15ZrO2-C, and 30ZrO2-C; it also contains the single point total pore volume, the t-plot volume of micropores, and the BJH volume of mesopores (adsorption branch) expressed as cm3/g for C, 5ZrO2-C, 15ZrO2-C, and 30ZrO2-C;

- "Raman" folder:
       - File "ZrO2.csv" contains the Raman spectra (Raman intensity in arbitrary units vs wavenumber in cm-1) of the zirconia catalyst before reaction, after reaction N°4 and after reaction N°10; 
       - File "TiO2.csv" contains the Raman spectra (Raman intensity in arbitrary units vs wavenumber in cm-1) of the zirconia catalyst before reaction, after reaction N°5 and after reaction N°11;

- "SEM" folder:
       - Files "5ZrO2-C_01.png", "5ZrO2-C_02.png", "15ZrO2-C_01.png", "15ZrO2-C_02.png", "30ZrO2-C_01.png", "30ZrO2-C_02.png", "C_01.png", "TiO2_01.png", and "ZrO2_01.png" contain the SEM electron images of the fresh catalysts corresponding to the filename;

- "TEM" folder:
       - Files "5ZrO2-C_01.png", "5ZrO2-C_02.png", "5ZrO2-C_03.png", "5ZrO2-C_04.png", "15ZrO2-C_01.png", "15ZrO2-C_02.png", "15ZrO2-C_03.png", "15ZrO2-C_04.png", "30ZrO2-C_01.png", "30ZrO2-C_02.png", "30ZrO2-C_03.png", and "30ZrO2-C_04.png" contain the TEM images of the fresh catalysts corresponding to the filename;
       - file "particle_size.csv" contains the measured particle diameters in nanometers for 5ZrO2-C, 15ZrO2-C, and 30ZrO2-C;

- "TGA" folder
       - File "TiO2.csv" contains the thermogravimetric analysis of TiO2 after reaction N°5 and after reaction N°11 expressed as time in minutes, temperature in Celsius degrees, mass of sample in milligrams and residual mass as percentage;

- "XPS" folder:
       - File "surface_elemental_analysis.csv" contains the binding energy in electronvolts and the relative quantities (expressed as atomic %) of the main components found in the XPS spectra of the pristine carbon support, of fresh 30ZrO2-C and of 30ZrO2-C after reaction N°19; 

- "XRD" folder:
       - Files "5ZrO2-C.csv", "15ZrO2-C.csv", and "C.csv" contain the X-ray diffractogram (diffracted intensity in arbitrary units vs Bragg angle in 2 theta degree) of the fresh catalyst corresponding to the filename;
       - File "30ZrO2-C.csv" contains the X-ray diffractogram (diffracted intensity in arbitrary units vs Bragg angle in 2 theta degree) of the fresh catalyst, of the catalyst after reaction N° 6, after reaction N°12 and after reaction N°19.
       - File "TiO2.csv" contains the X-ray diffractogram (diffracted intensity in arbitrary units vs Bragg angle in 2 theta degree) of the fresh catalyst, of the catalyst after reaction N° 5, and after reaction N°11.
       - File "ZrO2.csv" contains the X-ray diffractogram (diffracted intensity in arbitrary units vs Bragg angle in 2 theta degree) of the fresh catalyst, of the catalyst after reaction N° 4, and after reaction N°10.


# File Specifics

To create the .csv files were used the following specifics:

- Character set iso-8859-1 (Latin-1)
- Field delimiter « , » (comma)

# Methodologies

- Catalyst preparation
Bulk zirconium oxide (ZrO2) was prepared as follows: zirconium oxychloride octahydrate (ZrOCl2∙8H2O, Alfa Aesar, 98%) was dissolved in deionized water to obtain a concentration of 0.5 mol/L and transferred into a separatory funnel. Then, it was slowly added dropwise and under vigorous stirring to a basic solution prepared by diluting concentrated ammonia (NH3, Sigma Aldrich, 28 wt. %) down to 5 mol/L. The resulting suspension was stirred for 1 hour, filtered with a Buchner funnel and thoroughly washed with deionized water. Finally, the wet cake was dried at 120 °C overnight, grinded and calcined at 550 °C for 3 hours (heating rate = 5 °C/min).
Bulk titanium oxide (TiO2) was prepared as follows: two microemulsions were prepared by mixing 8.0 grams of cyclohexane (Cy, Sigma Aldrich, 99.7 %), 6.9 grams of Triton X-100 (TX-100, Thermo Fischer Scientific) and 3.1 grams of 1-hexanol (Hex, Merck, 98 %) to obtain a Cy/TX-100 ratio = 1.17 (wt/wt) and Hex/ T X-100 ratio = 0.46 (wt/wt). Then, 10.3 mL of [HNO3] = 5 mol/L were slowly added under stirring to one of the microemulsion, which was labelled “solution A”. The required amount of titanium (IV) n-butoxide (TB, Sigma Aldrich, 97 %) was slowly added under stirring to the second microemulsion, which was labelled “solution B”. The “solution B” was slowly poured in the “solution A” under vigorous stirring and left stirring at room temperature for 1 h to promote the hydrolysis of TB inside the micelles. Subsequently, the microemulsion was brought to reflux temperature (74 °C) and kept boiling for 5 h. The solid was recovered by centrifugation and washed 5 times with ethanol. After drying at 120 °C overnight, the powder was calcined at 400 °C for 3 h (heating rate = 2 °C/min).
Zirconium oxide supported over activated carbon (ZrO2/C) was prepared by incipient wetness impregnation (IWI). The commercial support (Norit SX2, Sigma127 Aldrich) was dried at 100 °C under vacuum for 2 hours to remove traces of adsorbed water; then, the amount of zirconium (IV) n-butoxide (Thermo Fischer Scientific, 80 wt. % solution in 1-butanol) required to obtain ZrO2 loadings equal to 5 wt. %, 15 wt. % and 30 wt. % was diluted with 1-butanol (VWR, 99.9 %) up to the volume required to entirely fill the porosity of the activated carbon (e.g., 2.6 mL of 1-butanol per gram of activated carbon). Prior to use, 1-butanol was dried over molecular sieves 3A (Merck). The resulting wet solid was left for 48 hours to slowly hydrolyse in contact with atmospheric moisture and then dried overnight at 100 °C. Finally, it was subjected to a thermal treatment in flowing N2 (20 mL/min) at 550 °C for 3 hours (heating rate of 5 °C/min).

- Catalysts characterization
Powder X-ray diffraction (XRD, Philips X’Pert Pro, PANalytical, UK) was carried out in Bragg-Brentano geometry with a Cu Kα X-ray source (l = 1.54178 Å, Ni-filtered). N2 multipoint adsorption/desorption isotherms (ASAP 2020, Micromeritics, USA) for carbon-containing samples and single-point BET measurements (Sorpty 1750, Fisons, UK) for ZrO2 and TiO2 were collected at -196 °C (77 K). Scanning electron images (EP EVO 50, Zeiss, DE) were acquired to determine the morphology of materials. Energy dispersive spectrometry (EDS) analysis (INCA X-Act detector with PentaFET Precision, Oxford Instrument Analytical, UK) was carried out to measure the elemental composition. Spectra were recorded for 60 seconds with an accelerating voltage of 20 kV. High resolution transmission electron microscopy images (TECNAI F20, FEI, USA) were collected operating at 200 KeV, with a scanning TEM accessory used in phase contrast mode; STEM images were recorded using a high angle annular dark field detector (HAADF). X-ray photoelectron spectroscopy (Axis DLD Ultra, KRATOS, UK) was carried out with a hemispherical analyser and monochromatized X-ray source (Al Ka at 1486.6 eV). The analysis chamber pressure was kept at 5·10-9 mbar, the sample surface was at a 90° angle in respect to the analyser to achieve a sampling depth of approximately 10 nm, and the analysis of non-conductive samples were carried out in sample charge compensation mode by bombarding the surface with an electron gun. Raman spectra were collected with a Raman microscope (InViaTM, Renishaw, UK) coupled with a confocal microscope (DM LM, Leica Microsystems, DE) and equipped with an Ar+ laser (514.5 nm) and a diode laser (785.0 nm). Thermogravimetric analyses (SDT Q600, TA Instrument, USA) were carried out in air from room temperature to 600 °C (heating rate =10 °C/min).

- Catalytic testing and product analysis
The bench-scale rig used is shown in Supplementary Figure 1. All the gas-phase catalytic runs were carried out at temperatures ranging from 250 to 425 °C and at atmospheric pressure in a conventional fixed-bed quartz reactor with a down-flow geometry. The catalysts were formed into pellets with particle size between 30 and 60 mesh (595-250 mm) before reaction. Acetic acid (AA, Sigma Aldrich, 99.8 %), pure or diluted with deionized water, was charged into a 5 mL syringe (Hamilton, USA) and fed into the plant with a syringe pump. through a gas-tight septum with a constant flow rate by means of volumetric pump (KDS 100 Legacy, KD Scientific, USA). The liquid reactant mixture was vaporized with a hot flux of an inert carrier gas (nitrogen, N2) controlled by MFC (5850E, Brooks, USA) flowing in a stainless-steel line kept at 220 °C. Typically, the flow rates of the liquid mixture and the N2 carrier were selected to obtain a molar fraction of AA equal to 3 mol. % in the gas-phase and a contact time (t) = 0.5 seconds at the reaction temperature with 0.5 cm3 of catalyst pellets. The effluent from the reactor was bubbled through two cold traps in series kept at 0 °C by means of an ice bath and filled with methanol (MeOH, Sigma Aldrich, 99.9 %) to absorb the condensable products. The liquid reaction mixtures were transferred into a 100 mL flask at regular intervals of time and 2 grams of a dodecane (Sigma-Aldrich, 99%) solution in MeOH (Conc. = 4∙10−5 mol/g) was added as the internal standard. The liquid reaction mixtures were analysed offline by GC-FID (GC 2010 PRO, Shimadzu, JP); the instrument was equipped with an autosampler, a flame ionization detector (FID), and an HP-5 capillary column (30 m × 320 µm × 0.25 µm) using helium (He) as the carrier. The temperature program used for both the GC-FID calibration and reaction mixtures analysis was as follows: the starting temperature (40 °C) was kept for 2 minutes, then was raised up to 220 °C with a heating rate of 20 °C/min and kept constant for 30 minutes. The gaseous products exiting the cold trap were driven to an online micro-GC (3000A, Agilent, USA) equipped with 3 columns: PlotQ, OV1 and a molecular sieve 5A, using argon (Ar) as the carrier and a thermal conductivity detector (TCD). Both the TCD calibration and the analysis of the reaction products were carried out isothermally at 60 °C. Unknown compounds were identified by means of a GC (6890, Agilent, USA) coupled with an Agilent HP-5 capillary column (30 m × 250 µm × 1.05 µm) and a MS detector (5973 mass analyser, Agilent, USA). Moreover, the retention times of unknown products were compared with those of commercial pure reference standards.

# Notes

The data are presented and discussed in the paper: "Promoting zirconia with carbon: enhanced hybrid ZrO2/C catalyst for the ketonization of diluted aqueous acetic acid " by Jacopo De Maron, Aytan Safarova, Catalin Ursu, Gaetano Maria D’Onofrio, Eleonora Tosi Brandi, Andrea Fasolini, Gloria Gottardi, Francesco Basile, Fabrizio Cavani, Tommaso Tabanelli, published by the Journal Carbon (Carbon 238 (2025) 120203; DOI:10.1016/j.carbon.2025.120203).



 
 

 
