

import numpy as np
import matplotlib.pyplot as plt
from model import PushTimeSerieTactileOneModel


exp_path = "path_here_to_your_experiment_folder"

model = PushTimeSerieTactileOneModel(model_path="path_here_to_your_trained_model.pth")



pull_data = np.loadtxt("path_here_to_your_pull_data.txt")
push_data = np.loadtxt("path_here_to_your_push_data.txt")
data = np.concatenate((push_data, pull_data), axis=0)

data_Ix = data[:,0]

# make sliding windows of dim 50 for prediction
window_size = 50
data_Ix = [data_Ix[i:i+window_size] for i in range(len(data_Ix)-window_size+1)]

predictions = []
for i in range(window_size):
    predictions.append(0)  # padding for initial values
for x in data_Ix:
    x = np.array(x)
    y = model.predict(x)
    predictions.append(float(y))

predictions = np.array(predictions).squeeze()


# plot with colored regions according to predictions
current_pred = -1

fig, ax = plt.subplots(figsize=(7.0, 3.6), dpi=150)
    
ax.plot(
    data[:, 0],
    color="black",
    linewidth=1.5,
)

ax.plot(data[:, 0], color="blue", linewidth=1.5)

start_idx = 0
current_pred = predictions[0]

for i in range(1, len(predictions)):
    if predictions[i] != current_pred:
        ax.axvspan(
            start_idx,
            i,
            alpha=0.25,
            zorder=0,
        )
        start_idx = i
        current_pred = predictions[i]

# last segment
ax.axvspan(
    start_idx,
    len(predictions),
    color=pred_colors[int(current_pred)],
    alpha=0.25,
    zorder=0,
)

ax.set_xlabel("Time [samples]")
ax.set_ylabel(r"$\mathrm{\tau}$ [dim.less]")
ax.grid(True, alpha=0.25, linestyle="--")
ax.margins(x=0)


fig.tight_layout()
plt.show()
